

/*<-------------------- steup --------------------------*/

var years = [2011, 2013, 2014, 2015, 2017, 2018, 2019];

var csvdata = d3.select("#csvdata").text();
csvdata = d3.csv.parse(csvdata);

var week = d3.time.format("%U"),
  month = d3.time.format("%m"),
  year = d3.time.format("%Y"),
  day = d3.time.format("%j"),
  dayofWeek = d3.time.format("%w"),
  format = d3.time.format("%Y-%m-%d"),
  calFormat = d3.time.format("%b-%d");

var svgWidth = 1280,
  svgHeight = 1200;

var colorRange = [
"#68D888",
"#CF6C2A",
"#CCDA40",
"#5B8866",
"#A27F49",
"#71D944",
"#C7D585",
"#7DD7BD",
"#5E8F34",
"#D3A839"];


var cellSize = 18,
  m = [40, ((svgWidth - cellSize * 53) / 2), 40, ((svgWidth - cellSize * 53) / 2)];

d3.select("body").append("div")
  .attr("id", "top")
  .style({"width": svgWidth, "margin": "auto", "height": "40px", "text-align":"left", "padding": "20px"});
  
d3.select("#top")
  .append("button")
    .attr({"class": "download", "type": "Button", "href": "#"})
    .on("click", crowbar)
    .text("Download SVG");

d3.select("#top")
  .append("span").style({"padding": "0px 0px 0px 15px"})
  .html("Analysis Year: ")
  .append("select").attr("id", "refYear").attr("onchange", "calendarRegen()")
  .selectAll("option")
  .data(years)
  .enter().append("option").html(function(d) { return d; });

document.getElementById("refYear").options[1].defaultSelected = true;


d3.select("body").append("div")
  .attr("id", "container")
  .style({"width": svgWidth, "margin": "auto"});

//format the data
var analysisYears = document.getElementById("refYear");
var refYear = +analysisYears.options[analysisYears.selectedIndex].text;

var days = d3.time.days(new Date(refYear, 0, 1), new Date(refYear + 1, 0, 1)),
  months = d3.time.months(new Date(refYear, 0, 1), new Date(refYear+1, 0, 1));

var variables = d3.keys(csvdata[0]);

//omit total value if it's present
var plotVariables = variables.filter(function(d) { 
  if(d.toLowerCase().indexOf("total") != -1) {
    return false;
  }
  else {
    return true;
  }});

var varColor = {};
var calColor = {};
variables.forEach(function(d, i) { 
  var data = calData(d);
  var calDomain = d3.extent(data, function(d) { return d.value; })

  calColor[d] = d3.scale.linear()
  .domain(calDomain)
  .range(["#fff", colorRange[i]]);

  varColor[d] = colorRange[i];
});


//for the graph
var width = svgWidth - m[1] - m[3],
  height = 300;

var activeDays = days;

var stackMethod = "Stacked"

var hourRange = [
"1 AM",
"2 AM",
"3 AM",
"4 AM",
"5 AM",
"6 AM",
"7 AM",
"8 AM",
"9 AM",
"10 AM",
"11 AM",
"Noon",
"1 PM",
"2 PM",
"3 PM",
"4 PM",
"5 PM",
"6 PM",
"7 PM",
"8 PM",
"9 PM",
"10 PM",
"11 PM",
"12 AM"];




















/* ---------------- data ------------------ */


function calData(input) {

  var dailyTotals = days.map(function(d, i) { 
    var dayTotal = d3.sum(csvdata.slice((i*24), (i*24 + 24)), function(p) { return +p[input]; });
    return {"id": d, "value": dayTotal};
  });
  return dailyTotals;
}

//extent is array of days
function gData(extent, method) {

  var hours = d3.range(24);
  var data_mapped = plotVariables.map(function(d, i) {
    return hours.map(function(dd, ii) {
      var val = d3.sum(extent, function(p) {
        return +csvdata[24 * (day(p) - 1) + dd][d];
      });

      val = val / extent.length

      return {x: ii, y: val};
    });
  }); 
  var stacked = d3.layout.stack();
  
  if(method == "Stacked") {
    var stackOut = stacked(data_mapped);
  }
  else if(method == "Wiggle") {
    var stackOut = stacked.offset("wiggle")(data_mapped);
  }
  else if(method == "Center Stream") {
    var stackOut = stacked.offset("silhouette")(data_mapped);
  }
  else {
    var stackOut = stacked(data_mapped);
  }

  return stackOut;
}



















/* ---------------- brush ------------------ */

var brushX = d3.scale.linear()
  //.domain(d3.extent(days, function(d) { return week(d); }))
  .domain([-1, 52])
  .range([0, width]);

var brushY = d3.scale.linear()
  //.domain(d3.extent(days, function(d) { return dayofWeek(d); }))
  .domain([-1, 6])
  .range([0, (cellSize * 7)]);

var brush = d3.svg.brush()
  .x(brushX)
  .y(brushY)
  //.on("brush", brushmove)
  .on("brush", brushed)
  .on("brushend", brushend);


function brushed() {
  var e = brush.extent(),
  nExtent;

  //if draggin preserve the width of the extent
  if (d3.event.mode === "move") {
    var x0 = Math.round(e[0][0]),
    x1 = x0 + Math.round(e[1][0] - e[0][0]);

    var y0 = Math.round(e[0][1]),
    y1 = y0 + Math.round(e[1][1] - e[0][1]);
  
    nExtent = [[x0, y0], [x1, y1]];
  }
  
  //otherwise if resizing round bouth dates
  else {
    nExtent = e.map(function(d) { 
      return d.map(function(dd) { return Math.round(dd); });
    });

    /*if empty when rounded, use floor and ceil instead
    if (nExtent[0][0] >= nExtent[1][0]) {
      nExtent[0][0] = Math.floor(e[0][0]);
      nExtent[0][1] = Math.floor(e[0][1]);
    }
    if (nExtent[0][1] >= nExtent [1][1]) {
      nExtent[1][0] = Math.ceil(e[1][0]);
      nExtent[1][1] = Math.ceil(e[1][1]);
    }*/    

  }

  d3.select(this).call(brush.extent(nExtent));

  calendar.selectAll(".day").classed("hidden", function(d) {
    return nExtent[0][0] >= week(d.id) || week(d.id) > nExtent[1][0]
      || nExtent[0][1] >= dayofWeek(d.id) || dayofWeek(d.id) > nExtent[1][1];
  });

  
  activeDays = days.filter(function(d) { 
    return nExtent[0][0] < week(d) && week(d) <= nExtent[1][0]
      && nExtent[0][1] < dayofWeek(d) && dayofWeek(d) <= nExtent[1][1];
    });

}


function brushend() {
  if (brush.empty()) { 
    calendar.selectAll(".hidden").classed("hidden", false); 
    activeDays = days
    brushTransition(activeDays);
  }
  else {
    brushTransition(activeDays);
  }
}

















/* ------------- Calendar -------------------- */

var calVariable = variables[0];
var data = calData(calVariable);

/* this is the original version
function monthPath(t0) {
  var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
      d0 = +dayofWeek(t0), w0 = +week(t0),
      d1 = +dayofWeek(t1), w1 = +week(t1);
  return "M" + (w0 + 1) * cellSize + "," + d0 * cellSize
      + "H" + w0 * cellSize + "V" + 7 * cellSize
      + "H" + w1 * cellSize + "V" + (d1 + 1) * cellSize
      + "H" + (w1 + 1) * cellSize + "V" + 0
      + "H" + (w0 + 1) * cellSize + "Z"; 
}
*/

// This is the custom month path for each year (ignore this code - just being fussy) I'll optimize this later
function monthPath(t0) {
  if (refYear == 2011) {
  
    if (t0 === months[3] || t0 === months[11]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else if (t0 === months[4]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0;
    }
    else {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
  }

  else if (refYear == 2013) {

    if (t0 === months[7] || t0 === months[10]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else if (t0 === months[8] || t0 === months[11]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0;
    }
    else {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
  }

 else if (refYear == 2014) {

    if (t0 === months[4]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else if (t0 === months[5]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0;
    }
    else {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
  }

  else if (refYear == 2015) {

    if (t0 === months[0] || t0 === months[9]){
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else if (t0 === months[1]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else if (t0 === months[2] || t0 === months[10]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
    else {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
  }


  else if (refYear == 2017) {

    if (t0 === months[0] || t0 === months[9]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
    else if (t0 === months[8]){
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
  }

  else if (refYear == 2018) {

    if (t0 === months[2] || t0 === months[5]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else if (t0 === months[3] || t0 === months[6]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0;
    }
    else {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
  }

  else if (refYear == 2019) {

    if (t0 === months[7] || t0 === months[10]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else if (t0 === months[8] || t0 === months[11]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0;
    }
    else {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
  }
}



var svg = d3.select("#container").append("svg")
  .attr("id", "visualization")
  .attr("width", svgWidth)
  .attr("height", svgHeight)
  .attr("xmlns", "http://www.w3.org/2000/svg");

var calendar = d3.select("#visualization").append("g")
  .attr("id", "calendar")
  .attr("transform", "translate(" + m[1] + "," + m[0] + ")");

var rect = calendar.selectAll(".day")
  .data(data)
.enter().append("rect")
  .attr({"class": "day", "width": cellSize, "height": cellSize})
  .attr("x", function(d) { return week(d.id) * cellSize; })
  .attr("y", function(d) { return dayofWeek(d.id) * cellSize; })
  .style("fill", function(d) { return calColor[calVariable](d.value); });
  //.datum(format);

calendar.selectAll(".month")
  .data(months)
.enter().append("path")
  .attr("class", "month")
  .attr("d", monthPath);

calendar.append("g").attr("class", "monthLabels")
  .attr("transform", "translate(0,-20)")
  .selectAll("text")
  .data(months)
  .enter().append("text")
  .attr("y", 0)
  .attr("x", function(d, i) { return (i * (width/12) + (width/24)) ;})
  .attr("dy", ".71em")
  .style("text-anchor", "middle")
  .text(function(d) { return d3.time.format("%B")(d); });

calendar.append("g").attr("class", "dayLabels")
  .attr("transform", "translate(-15, -3)")
  .selectAll("text")
  .data(["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"])
  .enter().append("text")
  .attr("y", function(d, i) { return (i * cellSize + cellSize/2); })
  .attr("dy", ".71em")
  .style("text-anchor", "end")
  .text(function(d) { return d; });


d3.select("#visualization").append("g")
  .attr("id", "brushG")
  .data(days)
  .attr("transform", "translate(" + m[1] + "," + m[0] + ")")
  .call(brush);

















/* ---------------- Menu Items ------------------ */

var menuItems = d3.select("body").append("div")
  .attr("id", "menuItems")
  .style({"position": "absolute", "width": svgWidth, "top": (3 * m[0] + cellSize * 7 + 20) + "px", "left": m[3] + "px", "text-align":"left"});

menuItems.append("span").html("Calendar Displays: ")
  .append("select").attr("id", "varList").attr("onchange", "calendarRemap()")
  .selectAll("option")
  .data(variables)
  .enter().append("option").html(function(d) { return d; });

menuItems.append("span").style({"padding": "0px 0px 0px 20px"})
  .html("Bar Chart Style: ")
  .append("select").attr("id", "chartStyle").attr("onchange", "formatTransition()")
  .selectAll("option")
  .data(["Stacked", "Wiggle", "Center Stream"])
  .enter().append("option").html(function(d) { return d; });

menuItems.append("span").style({"padding": "0px 0px 0px 20px"})
  .append("form").style({"display": "block", "overflow": "hidden", "float": "right"})
  .html("Dynamic Scaling: ")
  .append("input")
  .attr("type", "checkbox").attr("id", "dynScaling")
  .attr("onclick", "brushTransition(activeDays)");

document.getElementById("dynScaling").defaultChecked = true;



















/* ---------------- stacked graph ------------------ */



var x = d3.scale.ordinal()
  .domain(d3.range(24))
  .rangeRoundBands([0, width], .08);


function domainMax() {

  if(document.getElementById("dynScaling").checked) {

    var domainStack = gData(activeDays, stackMethod);
    return d3.max(domainStack, function(variable) { return d3.max(variable, function(d) { return d.y0 + d.y; }); });
  }

  else {
  
    var domainMap = plotVariables.map(function(d, i) {
      return csvdata.map(function(dd, ii) {
          return  {x: ii, y: +dd[d]};
      });
    });
    
    var domainStack = d3.layout.stack()(domainMap);
    return d3.max(domainStack, function(variable) { return d3.max(variable, function(d) { return d.y0 + d.y; }); });
  }
}


var y = d3.scale.linear()
  .domain([0, domainMax()])
  .rangeRound([height, 0])
  .nice();

/*
var color = d3.scale.ordinal()
  .domain(plotVariables)
  .range(colorRange);
*/

var xAxis = d3.svg.axis()
  .scale(x)
  .orient("bottom");

var yAxis = d3.svg.axis()
  .scale(y)
  .orient("left")
  .tickFormat(d3.format(".2s"));

var graph = d3.select("#visualization").append("g")
  .attr("id", "graph")
  .attr("transform", "translate(" + m[1] + "," + ((cellSize * 7) + m[0] + m[2] + 40) + ")");

graph.append("g")
  .attr("class", "x axis")
  .attr("transform", "translate(0," + height + ")")
  .call(xAxis)
.selectAll("text")
  .data(hourRange)
  .attr("y", 0)
  .attr("x", -15)
  .attr("transform", "rotate(-90)")
  .style("text-anchor", "end")
  .text(function(d) { return d; });

graph.append("g")
  .attr("class", "y axis")
  .call(yAxis)
  .append("text")
  .attr("id", "yAxisTitle")
  .attr("transform", "rotate(-90)")
  .attr("y", -50)
  .attr("x", -height/2)
  .attr("dy", ".71em")
  .style("text-anchor", "middle")
  .text("Daily Average End-Use Energy (Btu)");


graph.append("g")
  .attr("class", "gridHorizontal")
  .call(d3.svg.axis().scale(y)
    .orient("left")
    .tickFormat("")
    .tickSize(-width, 0));













/* -------------------- Legend --------------------- */


var legend = graph.append("g")
  .attr("id", "legend")
  .attr("transform", "translate(11," + (height + 65) + ")");

legend.selectAll("rect")
  .data(plotVariables)
.enter().append("rect")
  .attr({"width": x.rangeBand(), "height": 8})
  .attr("y", function(d, i) { return i * 20; })
  .style("fill", function(d) { return varColor[d]; });

legend.selectAll("text")
  .data(plotVariables)
.enter().append("text")
  .attr("y", function(d, i) { return (i * 20) + 8; } )
  .attr("x", x.rangeBand() + 8)
  .style("text-anchor", "start")
  .text(function(d) { return d; });






















/* ---------------- transitions ------------------ */

function init(method) {

  var layer = graph.selectAll(".layer")
    .data(gData(days, method))
  .enter().append("g")
    .attr("class", "layer")
    .style("fill", function(d, i) { return varColor[plotVariables[i]]; });


  var bar = layer.selectAll(".bar")
    .data(function(d) { return d; })
  .enter().append("rect").attr("class", "bar")
    .attr("x", function(dd) { return x(dd.x); })
    .attr("y", function(dd) { return height; })
    .attr("width", x.rangeBand())
    .attr("height", 0);

  bar.transition()
    .delay(function(p, i) { return i * 10; })
    .attr("y", function(p) { return y(p.y0 + p.y); })
    .attr("height", function(p) { return y(p.y0) - y(p.y0 + p.y); });

}


function brushTransition(actives) {


  y.domain([0, domainMax()]);

  d3.select(".y.axis").call(yAxis);
  d3.select(".gridHorizontal")
    .call(d3.svg.axis().scale(y)
      .orient("left")
      .tickFormat("")
      .tickSize(-width, 0));

  graph.selectAll(".layer")
    .data(gData(actives, stackMethod))
    .selectAll(".bar")
      .data(function(d) { return d; })
      .transition()
        .duration(200)
        .attr("y", function(p, i) { return y(p.y0 + p.y); })
        .attr("height", function(p) { return y(p.y0) - y(p.y0 + p.y); });

  d3.select("#yAxisTitle")
    .text("Daily Average End-Use Energy (Btu)" + " - " + 
      calFormat(actives[0]) + " to " + calFormat(actives[actives.length - 1]));

}

function formatTransition() {
  
  var chartStyle = document.getElementById("chartStyle");
  stackMethod = chartStyle.options[chartStyle.selectedIndex].text;

  graph.selectAll(".layer")
    .data(gData(activeDays, stackMethod))
    .selectAll(".bar")
      .data(function(d) { return d; })
      .transition()
        .duration(900)
        .attr("y", function(p, i) { return y(p.y0 + p.y); })
        .attr("height", function(p) { return y(p.y0) - y(p.y0 + p.y); });

}

function calendarRemap() {
  
  var varList = document.getElementById("varList");
  var variabletoPlot = varList.options[varList.selectedIndex].text;

  data = calData(variabletoPlot);

  calendar.selectAll(".day")
    .data(data)
  .transition()
    .style("fill", function(d) { return calColor[variabletoPlot](d.value); });
    //.datum(format);


}

function calendarRegen() {

  d3.select("#brushG")
  .call(brush.clear());

  brushend();

  refYear = +analysisYears.options[analysisYears.selectedIndex].text;
  
  days = d3.time.days(new Date(refYear, 0, 1), new Date(refYear + 1, 0, 1)),
  months = d3.time.months(new Date(refYear, 0, 1), new Date(refYear+1, 0, 1));

  activeDays = days;

  brushTransition(activeDays);

  var varList = document.getElementById("varList");
  var variabletoPlot = varList.options[varList.selectedIndex].text;

  data = calData(variabletoPlot);

  calendar.selectAll(".day")
    .data(data)
  .transition().duration(0)
    .attr("x", function(d) { return week(d.id) * cellSize; })
    .attr("y", function(d) { return dayofWeek(d.id) * cellSize; })
    .style("fill", function(d) { return calColor[variabletoPlot](d.value); });
    //.datum(format);

  d3.select("#brushG")
  .data(days)
  .call(brush);

  d3.selectAll(".month")
  .data(months)
  .transition().duration(0)
  .attr("d", monthPath);


}




init(stackMethod);



















































/* SVG Crowbar -------------------------------------------------*/




function crowbar() {
  var doctype = '<?xml version="1.0" standalone="no"?><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">';

  window.URL = (window.URL || window.webkitURL);

  var script = document.createElement('script');
  script.onload = initialize;
  script.src = "http://d3js.org/d3.v3.min.js";
  document.head.appendChild(script);

  function initialize() {
    var documents = [window.document],
        SVGSources = [];
    d3.selectAll("iframe").each(function() {
      if (this.contentDocument) {
        documents.push(this.contentDocument);
      }
    });
    documents.forEach(function(doc) {
      var styles = getStyles(doc);
      var newSources = getSources(doc, styles);
      // because of prototype on NYT pages
      for (var i = 0; i < newSources.length; i++) {
        SVGSources.push(newSources[i]);
      };
    })
    if (SVGSources.length > 1) {
      createPopover(SVGSources);
    } else if (SVGSources.length > 0) {
      download(SVGSources[0]);
    } else {
      alert("The Crowbar couldnâ€™t find any SVG nodes.");
    }
  }

  function createPopover(sources) {
    cleanup();

  var drag = d3.behavior.drag()
      .origin(function() {
        var el = d3.select(this)
        return {
          x: el.style("left").replace("px", ""),
          y: el.style("top").replace("px", "")
        }
      })
      .on("drag", dragmove);

    sources.forEach(function(s1) {
      sources.forEach(function(s2) {
        if (s1 !== s2) {
          if ((Math.abs(s1.top - s2.top) < 38) && (Math.abs(s1.left - s2.left) < 38)) {
            s2.top += 38;
            s2.left += 38;
          }
        }
      })
    })

    var body = d3.select("body");

    var buttons = body.append("div")
        .attr("class", "svg-crowbar")
        .style("z-index", 1e7)
        .style("position", "absolute")
        .style("top", 0)
        .style("left", 0);

    var button = buttons.selectAll(".crowbar-button")
        .data(sources)
      .enter().append("div")
        .attr("class", "crowbar-button")
        .style("position", "absolute")
        .style("top", function(d) { return (d.top + document.body.scrollTop) + "px"; })
        .style("left", function(d) { return (document.body.scrollLeft + d.left) + "px"; })
        .style("padding", "4px")
        .style("border-radius", "3px")
        .style("color", "white")
        .style("text-align", "center")
        .style("font-family", "'Helvetica Neue'")
        .style("background", "rgba(0, 0, 0, 0.8)")
        .style("box-shadow", "0px 4px 18px rgba(0, 0, 0, 0.4)")
        .style("cursor", "move")
        .text(function(d, i) { return "SVG #" + i + ": " + (d.id ? "#" + d.id : "") + (d.class ? "." + d.class : "")})
      .append("button")
        .style("width", "150px")
        .style("font-size", "12px")
        .style("line-height", "1.4em")
        .style("margin", "5px 0 0 0")
        .text("Download")
        .on("click", function(d, i) {
          d3.event.preventDefault();
          download(d);
        });

    buttons.selectAll(".crowbar-button").call(drag);

    var html = body.append("div")
        .attr("class", "svg-crowbar")
        .style("background", "rgba(255, 255, 255, 0.7)")
        .style("position", "fixed")
        .style("left", 0)
        .style("top", 0)
        .style("width", "100%")
        .style("height", "100%");

    function dragmove(d) {
      d3.select(this)
          .style("left", d3.event.x + "px")
          .style("top", d3.event.y + "px");
    }
  }

  function cleanup() {
    d3.selectAll(".svg-crowbar").remove();
  }



  function getSources(doc, styles) {
    var svgInfo = [],
        svgs = d3.select(doc).selectAll("svg");

    styles = (styles === undefined) ? "" : styles;

    svgs.each(function () {
      var svg = d3.select(this);
      svg.attr("version", "1.1")
        .insert("defs", ":first-child")
          .attr("class", "svg-crowbar")
        .append("style")
          .attr("type", "text/css");

      // removing attributes so they aren't doubled up
      svg.node().removeAttribute("xmlns");
      svg.node().removeAttribute("xlink");

      // These are needed for the svg
      if (!svg.node().hasAttributeNS(d3.ns.prefix.xmlns, "xmlns")) {
        svg.node().setAttributeNS(d3.ns.prefix.xmlns, "xmlns", d3.ns.prefix.svg);
      }

      if (!svg.node().hasAttributeNS(d3.ns.prefix.xmlns, "xmlns:xlink")) {
        svg.node().setAttributeNS(d3.ns.prefix.xmlns, "xmlns:xlink", d3.ns.prefix.xlink);
      }

      var source = (new XMLSerializer()).serializeToString(svg.node()).replace('</style>', '<![CDATA[' + styles + ']]></style>');
      var rect = svg.node().getBoundingClientRect();
      svgInfo.push({
        top: rect.top,
        left: rect.left,
        width: rect.width,
        height: rect.height,
        class: svg.attr("class"),
        id: svg.attr("id"),
        childElementCount: svg.node().childElementCount,
        source: [doctype + source]
      });
    });
    return svgInfo;
  }

  function download(source) {
    var filename = "untitled";

    if (source.id) {
      filename = source.id;
    } else if (source.class) {
      filename = source.class;
    } else if (window.document.title) {
      filename = window.document.title.replace(/[^a-z0-9]/gi, '-').toLowerCase();
    }

    var url = window.URL.createObjectURL(new Blob(source.source, { "type" : "text\/xml" }));

    var a = d3.select("body")
        .append('a')
        .attr("class", "svg-crowbar")
        .attr("download", filename + ".svg")
        .attr("href", url)
        .style("display", "none");

    a.node().click();

    setTimeout(function() {
      window.URL.revokeObjectURL(url);
    }, 10);
  }

  function getStyles(doc) {
    var styles = "",
        styleSheets = doc.styleSheets;

    if (styleSheets) {
      for (var i = 0; i < styleSheets.length; i++) {
        processStyleSheet(styleSheets[i]);
      }
    }

    function processStyleSheet(ss) {
      if (ss.cssRules) {
        for (var i = 0; i < ss.cssRules.length; i++) {
          var rule = ss.cssRules[i];
          if (rule.type === 3) {
            // Import Rule
            processStyleSheet(rule.styleSheet);
          } else {
            // hack for illustrator crashing on descendent selectors
            if (rule.selectorText) {
              if (rule.selectorText.indexOf(">") === -1) {
                styles += "\n" + rule.cssText;
              }
            }
          }
        }
      }
    }
    return styles;
  }

}